var backside = false;
var flipShown = false; 
var animation = {duration:0, starttime:0, to:1.0, now:0.0, from:0.0,  firstElement:null, timer:null}; 

function setup () {
	var timestamp = counter();
	humanDate(timestamp);
}

function counter () {
	var epoch = document.getElementById('epochDate');
	var d = new Date();
	var time = d.getTime();
	var timestamp = Math.floor(time/1000);
	epoch.innerText = timestamp;
	setTimeout("counter()", 1000);
	return timestamp;
}       

function humanDate(timestamp) {
	var human = document.getElementById('humanDate');
	var theDate = new Date(timestamp * 1000);
	var month = theDate.getMonth();
	var monthArray = Array('Jan','Feb','Mar','Apr','May','Jun','Jul','Aug','Sep','Oct','Nov','Dec');
	var day = theDate.getDate();
	var year = theDate.getFullYear();
	var hour = theDate.getHours();
	var minute = theDate.getMinutes();
	var seconds = theDate.getSeconds();
	if ( String(hour).length == 1) 
		hour = '0' + hour;
	if ( String(minute).length == 1) 
		minute = '0' + minute;
	if ( String(seconds).length == 1) 
		seconds = '0' + seconds;
	var dateString = monthArray[month] + " " + day + ", " + year + " " + hour + ":" + minute + ":" + seconds;
	human.innerText = dateString;
}

function docopy (event) {
	var epoch = document.getElementById('epochDate');
	event.clipboardData.setData('text/plain', epoch.innerText);
	event.preventDefault();
	event.stopPropagation();
}

function dopaste (event) {
	
	var human = document.getElementById('humanDate');
	var clip = event.clipboardData.getData('text/plain');
	
	clip = clip.replace(/,/g, '');

	humanDate(clip);

	event.preventDefault();
	event.stopPropagation();
}

function showFront (event) {
	var front = document.getElementById("front");
	var back = document.getElementById("back");
	
	if (window.widget)
		widget.prepareForTransition("ToFront");
	
	front.style.display="block";
	back.style.display="none";
	
	if (window.widget)
		setTimeout ('widget.performTransition();', 0);
		
	backside = false;
}

function showBack (event) {
	var front = document.getElementById("front");
	var back = document.getElementById("back");
	
	if (window.widget)
		widget.prepareForTransition("ToBack");
	
	front.style.display="none";
	back.style.display="block";
	
	if (window.widget)		
		setTimeout ('widget.performTransition();', 0);	

	backside = true;
	
}

function mousemove(event) {     
	if (!flipShown) {         
		if (animation.timer != null) {
			clearInterval(animation.timer);
			animation.timer = null;         
		}  
       
		var starttime = (new Date).getTime() - 13; 

		animation.duration = 500;
		animation.starttime = starttime;
		animation.firstElement = document.getElementById('prefsFlipper');
		animation.secondElement = document.getElementById('prefsFlipper2');
		animation.timer = setInterval("animate();", 13);
		animation.from = animation.now;
		animation.to = 1.0;
		animate();
		flipShown = true;
	} 
} 

function mouseexit (event) {     
	if (flipShown) {
		// fade in the flip widget
		if (animation.timer != null) {
			clearInterval(animation.timer);
			animation.timer = null;
		}

		var starttime = (new Date).getTime() - 13;
		animation.duration = 500;
		animation.starttime = starttime;
		animation.firstElement = document.getElementById('prefsFlipper');
		animation.secondElement = document.getElementById('prefsFlipper2');
		animation.timer = setInterval("animate();", 13);
		animation.from = animation.now;
		animation.to = 0.0;
		animate();
		flipShown = false;
	} 
} 

function animate() {     
	var T;
	var ease;
	var time = (new Date).getTime(); 

	T = limit_3(time-animation.starttime, 0, animation.duration);
	if (T >= animation.duration) {
		clearInterval(animation.timer);
		animation.timer = null;
		animation.now = animation.to;
	}
	else {
		ease = 0.5 - (0.5 * Math.cos(Math.PI * T / animation.duration));
		animation.now = computeNextFloat(animation.from, animation.to, ease);
	}     
	
	animation.firstElement.style.opacity = animation.now;  
	animation.secondElement.style.opacity = animation.now;  
} 

function limit_3 (a, b, c) {
	return a < b ? b : (a > c ? c : a); 
} 

function computeNextFloat (from, to, ease) {
	return from + (to - from) * ease; 
}
